/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: WmlParser.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml.wap;

import java.io.*;

/**
 * A parser for WML built on top of the WbxmlParser by
 * setting the corresponding TagTable, AttrStartTable and
 * AttrValueTable defined in the class Wml
 */
public class WmlParser extends WbxmlParser {

    /**
     * Constructor declaration
     *
     *
     * @param in
     *
     * @see
     */
    public WmlParser(InputStream in) throws IOException {
	super(in);

	setTagTable(0, Wml.tagTable);
	setAttrStartTable(0, Wml.attrStartTable);
	setAttrValueTable(0, Wml.attrValueTable);
    }

    /*
     * public ParseEvent parseWapExtension (int id) {
     * 
     * public void ext_i (int id, String par) throws SAXException {
     * String dec = "$("+par+")";
     * dh.characters (dec.toCharArray (), 0, dec.length ());
     * }
     * 
     * public void ext_t (int id, int par) throws SAXException {
     * StringBuffer buf = new StringBuffer ();
     * 
     * while (stringTable [par] != 0)
     * buf.append (stringTable [par++]);
     * 
     * ext_i (id, buf.toString ());
     * }
     * public void opaque (byte [] bytes) throws SAXException {
     * throw new SAXException ("OPAQUE invalid in WML");
     * }
     * public void ext (int id)  throws SAXException {
     * throw new SAXException ("EXT_"+id+" reserved in WML");
     * }
     */
}

